<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns="http://www.w3.org/1999/xhtml">

<xsl:output
	method="html"
	encoding="UTF-16"
	doctype-public="-//W3C//DTD XHTML 1.1//EN"
	doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"
	indent="yes"
	cdata-section-elements="style script"/>

<xsl:include href="Filter%20Settings.xslt"/>

<xsl:template match="/root">
	<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="content-type" content="text/html; charset=utf-16" />
		<link rel="stylesheet" href="../css/default.css" media="all" charset="utf-8" type="text/css" />
		<link rel="stylesheet" href="../css/tag_cloud_detail.css" media="all" charset="utf-8" type="text/css" />
		<link rel="stylesheet" href="../css/print.css" media="print" charset="utf-8" type="text/css" />
		<link rel="stylesheet" href="../css/filterSettings.css" media="screen,print" charset="utf-8" type="text/css" />
		<link rel="stylesheet" href="../css/tablesortCommon.css" media="screen,print" charset="utf-8" type="text/css" />
		<link rel="stylesheet" href="../css/zero_states.css" media="all" charset="utf-8" type="text/css" />	
		
<!-- Inline Styles -->
		<style type="text/css">
	.financial td.dateHeader, td.checkNumberHeader { width: 60pt; }
	.financial td.debitHeader, td.creditHeader, td.balanceHeader { width: 80pt; }
		</style>
		
		<script type="text/javascript" src="../js/jquery.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/jquery.metadata.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/jquery.tablesorter.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/tablesorterParsers.js" charset="utf-8"></script>
		<!-- <script type="text/javascript" src="../js/transactionDetail.js" charset="utf-8"></script> -->
		<script type="text/javascript" src="../js/filterSettings.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/quickzoomTx.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/utils.js" charset="utf-8"></script>

		<script type="text/javascript">
function TransactionDetailInit() {
	MultiTableSortInit("table.transactionDetail");
	<!-- UserTagsInit(); -->
	QuickZoomTransactionsInit();
	FilterSettingsInit(true);
}
<!--
function AddToSidebar(anchor, tagID) {
	anchor=$(anchor);
	if (anchor.hasClass("disabled"))
		return false;
	if( window.viewController )
		window.viewController.AddTagIDToSidebar(tagID);
	return false;
}
-->
$(TransactionDetailInit);
		</script>
	</head>
	<body id="tagCloudDeatil">
		<div id="outerWrapper">
			<xsl:apply-templates select="filterSettings"/>

			<!-- Do we have any data? -->
			<xsl:choose>
				<xsl:when test="count(currency)>0">
				<!-- Begin: innerWrapper - WITH data -->
					<div id="innerWrapper" class="fullWidth clearAfter">
							<xsl:apply-templates select="currency"/>
					</div><!-- End: innerWrapper -->
				</xsl:when>	
				
				<xsl:otherwise>
					<!-- Begin: innerWrapper - NO data -->
					<div id="innerWrapperZeroDataCategory" class="fullWidth clearAfter">
						<div class="zeroState">
							<div class="noDataA">
								<p class="first">You have no transactions for the selected settings.</p>
								<p class="second">Try updating your settings above.</p>
							</div>	
						</div>
					</div><!-- End: innerWrapper -->
				</xsl:otherwise>	
			</xsl:choose>
		</div><!-- END outerWrapper -->
	</body>
	</html>
</xsl:template>


<xsl:template match="currency">
	<!-- <span class="currencyID"><h2><xsl:value-of select="@currencyID"/></h2></span> -->
	<!-- <span class="tagName"><xsl:value-of select="tagName"/></span> -->
	<xsl:apply-templates select="tagName"/>
	<xsl:apply-templates select="tagNameMedium"/>
	<xsl:apply-templates select="tagNameSmall"/>

		<xsl:choose>
			<xsl:when  test="tagTotal[@sign='negative']">
				<span class="tagTotal negative"><xsl:value-of select="tagTotal"/></span>
			</xsl:when>
			<xsl:otherwise>
				<span class="tagTotal"><xsl:value-of select="tagTotal"/></span>
			</xsl:otherwise>
		</xsl:choose>

	<xsl:apply-templates select="tagBundle"/>
</xsl:template>


<xsl:template match="tagName">
	<span class="tagName"><xsl:value-of select="."/></span>
</xsl:template>


<xsl:template match="tagNameMedium">
	<span class="tagNameMedium"><xsl:value-of select="."/></span>
</xsl:template>


<xsl:template match="tagNameSmall">
	<span class="tagNameSmall"><xsl:value-of select="."/></span>
</xsl:template>


<xsl:template match="tagBundle">	
	<xsl:if test="count(../tagBundle) > 1">
		<div class="tableHeader"><xsl:value-of select="@name"/></div>
	</xsl:if>

	<table class="transactionDetail">
		<thead>
			<tr>
				<th class='dateHeader {{sorter: "{/root/dateSort}"}}'>Date</th>
				<th class='account'>Account</th>
				<th class='payeeHeader'>Payee</th>
				<th class='categoryHeader'>Category</th>
				<th class='tagsHeader'>Tags</th>
				<th class='amountHeader currency {{sorter: "qCurrency"}}'>Amount</th>
			</tr>
		</thead>
		
		<tbody>
			<xsl:apply-templates select="transactionEntry"/>
		</tbody>

		<xsl:if test="count(../tagBundle) > 1">
			<tfoot>
				<tr>
					<xsl:choose>
						<xsl:when  test="total[@sign='negative']">
							<td class='subTotal negative' colspan="6"><strong><xsl:value-of select="total"/></strong></td>
						</xsl:when>
						<xsl:otherwise>
							<td class='subTotal' colspan="6"><strong><xsl:value-of select="total"/></strong></td>
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</tfoot>
		</xsl:if>
	</table>
</xsl:template>


<xsl:template match="transactionEntry">
	<tr id="transaction_{@quickenID}" class="transactionRow" quickenid="{@quickenID}">
		<td class="date"><xsl:value-of select="date"/></td>
		<td class="account"><xsl:value-of select="account"/></td>		
		<td class="payee"><xsl:value-of select="payee"/></td>
		<td class="category">
			<ul class="userTags">
				<xsl:apply-templates select="categoryTag"/>
			</ul>
		</td>
		<td class="tags">
			<ul class="userTags">
				<xsl:apply-templates select="userTag"/>
			</ul>
		</td>
		
		<xsl:choose>
			<xsl:when  test="amount[@sign='negative']">
				<td class="amount negative"><xsl:value-of select="amount"/></td>
			</xsl:when>
			<xsl:otherwise>
				<td class="amount"><xsl:value-of select="amount"/></td>
			</xsl:otherwise>
		</xsl:choose>
	</tr>
</xsl:template>

<xsl:template match="userTag">
	<li><xsl:value-of select="."/></li>
</xsl:template>


<xsl:template match="categoryTag">
	<li><xsl:value-of select="."/></li>
</xsl:template>


<xsl:template match="dateSort" />

</xsl:stylesheet>
